const express = require('express');
const multer = require('multer');
const fs = require('fs');
const { PDFDocument } = require('pdf-lib');
const path = require('path');

const app = express();
const upload = multer({ dest: 'uploads/' });

app.use(express.static('public'));

app.use('/css', express.static(path.join(__dirname, 'node_modules/bootstrap/dist/css')))
app.use('/cs2', express.static(path.join(__dirname, 'node_modules/bootstrap-4-dark-mode')))

app.use('/ijs', express.static(path.join(__dirname, 'node_modules/bootstrap/dist/js')))
app.use('/ijs', express.static(path.join(__dirname, 'node_modules/jquery/dist')))

app.use(express.json());
app.use(express.urlencoded({ extended: true }));

app.use(express.static('public'));
app.set('view engine', 'html');

app.get('/', async function (req, res) {
    return res.send('index');
});

app.post('/merge', upload.array('pdfs', 3), async (req, res) => {
    try {
        const pdfPaths = req.files.map(file => path.join(__dirname, file.path));
        const pdfDocs = await Promise.all(pdfPaths.map(async (pdfPath) => {
            const pdfBytes = fs.readFileSync(pdfPath);
            return await PDFDocument.load(pdfBytes);
        }));

        const mergedPdf = await PDFDocument.create();

        for (const pdfDoc of pdfDocs) {
            const copiedPages = await mergedPdf.copyPages(pdfDoc, pdfDoc.getPageIndices());
            copiedPages.forEach(page => mergedPdf.addPage(page));
        }

        const name = await generateRandomString(8) + ".pdf";
        const mergedPdfFile = await mergedPdf.save();
        const outputPath = path.join(__dirname, name);
        await fs.writeFileSync(outputPath, mergedPdfFile);

        res.download(outputPath, name, () => {
            // Eliminar los archivos temporales
            pdfPaths.forEach(pdfPath => fs.unlinkSync(pdfPath));
            fs.unlinkSync(outputPath);
        });
    } catch (error) {
        return res.status(500).redirect('/error.html');
    }
});

app.listen(3000, () => {
    console.log('Servidor iniciado en http://localhost:3000');
});


async function generateRandomString(length) {
    const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let result = '';
    for (let i = 0; i < length; i++) {
        const randomIndex = Math.floor(Math.random() * characters.length);
        result += characters[randomIndex];
    }
    return result;
}
